#pragma once

#include <yplatform/net/socket.h>
#include <sys/socket.h> // getsockopt
namespace {
#include <contrib/libs/linux-headers/linux/tcp.h>
typedef tcp_info linux_tcp_info;
}

namespace yplatform { namespace net {

inline string collect_tcp_stats(tcp_socket& socket)
{
    linux_tcp_info tcp_info;
    socklen_t tcp_info_length = sizeof(tcp_info);
    if (::getsockopt(
            socket.raw_socket().native_handle(),
            SOL_TCP,
            TCP_INFO,
            (void*)&tcp_info,
            &tcp_info_length) == 0)
    {
        std::stringstream ss;
        ss.precision(3);
        ss << "snd_mss:" << std::to_string(tcp_info.tcpi_snd_mss);
        ss << ",rcv_mss:" << std::to_string(tcp_info.tcpi_rcv_mss);
        ss << ",pmtu:" << std::to_string(tcp_info.tcpi_pmtu);
        ss << ",rtt:" << std::to_string(tcp_info.tcpi_rtt);
        ss << ",rttvar:" << std::to_string(tcp_info.tcpi_rttvar);
        ss << ",min_rtt:" << std::to_string(tcp_info.tcpi_min_rtt);
        ss << ",rcv_rtt:" << std::to_string(tcp_info.tcpi_rcv_rtt);
        ss << ",rcv_space:" << std::to_string(tcp_info.tcpi_rcv_space);
        ss << ",segs_out:" << std::to_string(tcp_info.tcpi_segs_out);
        ss << ",segs_in:" << std::to_string(tcp_info.tcpi_segs_in);
        ss << ",total_retrans:" << std::to_string(tcp_info.tcpi_total_retrans);
        ss << ",lost:" << std::to_string(tcp_info.tcpi_lost);
        return ss.str();
    }

    return {};
}

}}