#pragma once

#include <boost/thread/mutex.hpp>
#include <set>

namespace yplatform { namespace net {

template <typename T>
class thread_safe_set
{
public:
    typedef boost::unique_lock<boost::mutex> uniq_lock_t;
    typedef std::set<T> set_t;

    void insert(const T& val)
    {
        uniq_lock_t lck(mux_);
        set_.insert(val);
    }
    void erase(const T& val)
    {
        uniq_lock_t lck(mux_);
        set_.erase(val);
    }
    void clear()
    {
        uniq_lock_t lck(mux_);
        set_.clear();
    }
    std::size_t size()
    {
        uniq_lock_t lck(mux_);
        return set_.size();
    }
    std::size_t count()
    {
        return size();
    }
    bool empty()
    {
        uniq_lock_t lck(mux_);
        return set_.empty();
    }
    void lock()
    {
        mux_.lock();
    }
    void unlock()
    {
        mux_.unlock();
    }
    set_t& get_set()
    {
        return set_;
    }
    uniq_lock_t get_lock()
    {
        return uniq_lock_t(mux_);
    }

private:
    set_t set_;
    boost::mutex mux_;
};

}}
