#pragma once

#include <boost/range/iterator_range.hpp>
#include <string>

namespace std {
template <typename CharT, typename TraitsT, typename AllocT, typename IteratorT>
std::basic_string<CharT, TraitsT, AllocT>& operator+=(
    std::basic_string<CharT, TraitsT, AllocT>& dst,
    boost::iterator_range<IteratorT> const& src)
{
    return dst.append(src.begin(), src.end());
}

}
