#pragma once

#include <boost/asio/io_service.hpp>

namespace yplatform {

// This natty ad-hoc solution prevents an io service in
// one reactor from being destroyed earlier than its' io objects
// stored in another reactor (i.e. binded to callbacks).
class io_service_with_shutdown : public boost::asio::io_service
{
public:
    io_service_with_shutdown(size_t concurrency_hint) : boost::asio::io_service(concurrency_hint)
    {
    }

    void shutdown()
    {
        boost::asio::execution_context::shutdown();
    }
};

}
