#pragma once

#include <yplatform/reactor/detail/io_service_with_shutdown.h>
#include <yplatform/log.h>
#include <boost/asio/io_service.hpp>
#include <boost/thread/thread.hpp>
#include <string>

namespace yplatform {

class io_pool : public yplatform::log::contains_logger
{
public:
    // User is responsibile for concurrency_hint correctness.
    io_pool(boost::asio::io_service& io, size_t concurrency_hint);
    io_pool(size_t concurrency_hint);
    ~io_pool();

    boost::asio::io_service* io();
    const boost::asio::io_service* io() const;

    std::vector<boost::thread::id> run();
    // Stops io, drops all pending handlers and timers.
    void stop();

    void set_name(const std::string& name);

    std::size_t size() const;

private:
    void run_worker(std::size_t n);

    io_service_with_shutdown* io_wrapper_;
    boost::asio::io_service* io_;
    boost::thread_group workers_;
    std::string name_;
    size_t concurrency_;
    bool external_;
};

typedef boost::shared_ptr<io_pool> io_pool_ptr;

}
