#pragma once

#include <boost/asio/basic_waitable_timer.hpp>
#include <ctime>
#include <chrono>

namespace yplatform { namespace time_traits {

using clock = std::chrono::steady_clock;
using timer = boost::asio::basic_waitable_timer<clock>;
using timer_ptr = std::shared_ptr<timer>;
using time_point = clock::time_point;
using duration = clock::duration;
using std::chrono::hours;
using std::chrono::minutes;
using std::chrono::seconds;
using std::chrono::milliseconds;
using std::chrono::microseconds;
using std::chrono::nanoseconds;
using std::chrono::duration_cast;
using float_seconds = std::chrono::duration<double>;

inline std::string to_simple_string(time_t t)
{
    std::string time_str;
    time_str.resize(20);
    std::tm localtime_buff;
    std::strftime(
        &time_str[0], time_str.size(), "%Y-%m-%d %H:%M:%S", localtime_r(&t, &localtime_buff));
    time_str.resize(19);
    return time_str;
}

inline std::string to_string(const duration& d)
{
    std::string buf;
    buf.resize(14);
    int ret = snprintf(&buf[0], buf.size(), "%.3f", duration_cast<float_seconds>(d).count());
    return (ret > 0 && ret < 14) ? (buf.resize(ret), buf) : std::string("inval");
}

inline auto get_seconds_count(const duration& d)
{
    return duration_cast<seconds>(d).count();
}

} // namespace time_traits
} // namespace yplatform
