#pragma once

#include <yplatform/string_config.h>
#include <boost/algorithm/string.hpp>
#include <sstream>
#include <iostream>
namespace yplatform {
namespace util {

namespace {
std::locale loc;
}

template <typename Rng1, typename Rng2>
bool iequals(Rng1 const& r1, Rng2 const& r2, std::locale const& l = loc)
{
    return boost::iequals(r1, r2, l);
}

template <typename Rng1, typename Rng2>
bool istarts_with(Rng1 const& input, Rng2 const& test, std::locale const& l = loc)
{
    return boost::istarts_with(input, test, l);
}

template <typename EndPoint>
std::string address_string(EndPoint const& ep)
{
    std::ostringstream os;
    os << ep.address().to_string() << ':' << ep.port();
    return os.str();
}

template <typename C, typename T, typename X>
std::basic_ostream<C, T>& strip_crlf(std::basic_ostream<C, T>& stream, X const x)
{
    for (typename X::const_iterator i = x.begin(); i != x.end(); ++i)
    {
        switch (*i)
        {
        case '\n':
            stream << "<lf>";
            break;
        case '\r':
            stream << "<cr>";
            break;
        default:
            stream << *i;
            break;
        }
    }
    return stream;
}

template <typename StreamT, typename T>
void log_cmd(StreamT& stream, boost::iterator_range<T> const& rng, std::size_t const& lim)
{
    typedef boost::iterator_range<T> RangeT;
    if (rng.empty()) return;

    std::size_t size = rng.size();
    if (size <= lim)
    {
        RangeT r1(rng);
        if (r1.back() == '\n') r1.advance_end(-1);
        stream << r1;
        return;
    }

    RangeT r1(rng);
    r1.advance_end((lim / 2) - size);
    stream << r1;
    stream << " <... " << (size - (lim / 2) * 2) << " bytes ...> ";
    r1 = rng;
    r1.advance_begin(size - (lim / 2));
    if (r1.back() == '\n') r1.advance_end(-1);
    stream << r1;
}

template <typename StreamT, typename X>
void log_strip_cmd(StreamT& stream, X const& rng, std::size_t const& lim)
{
    std::stringstream local_stream;
    strip_crlf(local_stream, rng);
    string stripped = local_stream.str();
    log_cmd(stream, boost::make_iterator_range(stripped.begin(), stripped.end()), lim);
}

}

// Backward compatibility.
using util::iequals;
using util::istarts_with;

}
