#pragma once

#ifndef __GNUC__
#error "Atomic counters not implemented in your platform."
#endif

#include <stdint.h>

namespace yplatform { namespace util {

template <typename T>
struct basic_atomic_counter
{
public:
    basic_atomic_counter(const T& t) : obj_(t)
    {
    }

    inline operator T() const
    {
        __sync_synchronize();
        T tmp = obj_;
        __sync_synchronize();
        return tmp;
    }

    inline basic_atomic_counter<T>& operator=(T val)
    {
        __sync_lock_test_and_set(&obj_, val);
        return *this;
    }

    inline T operator++()
    {
        return __sync_add_and_fetch(&obj_, static_cast<T>(1));
    }

    inline T operator++(int)
    {
        return __sync_fetch_and_add(&obj_, static_cast<T>(1));
    }

    inline T operator+=(T val)
    {
        return __sync_add_and_fetch(&obj_, val);
    }

    inline T operator--()
    {
        return __sync_sub_and_fetch(&obj_, static_cast<T>(1));
    }

    inline T operator--(int)
    {
        return __sync_fetch_and_sub(&obj_, static_cast<T>(1));
    }

    inline T operator-=(T val)
    {
        return __sync_sub_and_fetch(&obj_, val);
    }

    inline T exchange(T old_val, T new_val)
    {
        return __sync_val_compare_and_swap(&obj_, old_val, new_val);
    }

private:
    volatile T obj_;
};

typedef basic_atomic_counter<int64_t> atomic_count;

}}
