#pragma once

#include <boost/iterator/iterator_traits.hpp>

#include <cctype>
#include <time.h>

namespace yplatform { namespace util {

struct ddmmyyyy
{
    short unsigned dd;
    short unsigned mm;
    short unsigned yyyy;
};

template <typename S>
S& operator<<(S& stream, ddmmyyyy const& d)
{
    return stream << d.dd << '/' << d.mm << '/' << d.yyyy;
}

struct date_full
{
    short unsigned dd;
    short unsigned mm;
    short unsigned yyyy;

    short signed hour;
    short unsigned min;
    short unsigned sec;

    short zone;
};

template <typename Number, typename Iterator>
bool parse_short(
    Number& sh,
    unsigned min_digits,
    unsigned max_digits,
    Iterator& begin,
    Iterator const& end)
{
    typedef typename boost::iterator_reference<Iterator>::type ref_t;
    typedef typename boost::iterator_value<Iterator>::type val_t;
    unsigned digits = 1;
    sh = 0;
    while (begin != end && digits <= max_digits)
    {
        ref_t v = *begin;
        if (!std::isdigit(v)) return (digits >= min_digits && digits <= max_digits);

        sh *= 10;
        sh += v - static_cast<val_t>('0');
        ++digits;
        ++begin;
    }

    return true;
}

template <typename N, typename Iterator>
bool parse_month(N& mon, Iterator& begin, Iterator const& end)
{
    typedef typename boost::iterator_reference<Iterator>::type ref_t;
    typedef typename boost::iterator_value<Iterator>::type val_t;

    mon = 0;
    if (begin == end) return false;

    ref_t ref = *begin;

    switch (std::tolower(ref))
    {
    default:
        return false;

    case static_cast<val_t>('j'): // jan jun jul
    {
        if (++begin == end) return false;
        ref_t ref2 = *begin;
        switch (std::tolower(ref2))
        {
        default:
            return false;

        case static_cast<val_t>('a'):
            if (++begin == end || std::tolower(*begin) != static_cast<val_t>('n')) return false;
            mon = 0;
            ++begin;
            return true;

        case static_cast<val_t>('u'):
        {
            if (++begin == end) return false;
            ref_t ref3 = *begin;
            switch (std::tolower(ref3))
            {
            default:
                return false;

            case static_cast<val_t>('n'):
                mon = 5;
                ++begin;
                return true;

            case static_cast<val_t>('l'):
                mon = 6;
                ++begin;
                return true;
            }
        }
        }
    } // case j

    case static_cast<val_t>('f'): // feb
    {
        if (++begin == end || *begin != static_cast<val_t>('e') || ++begin == end ||
            *begin != static_cast<val_t>('b'))
            return false;

        mon = 1;
        ++begin;
        return true;
    } // case f

    case static_cast<val_t>('m'): // mar may
    {
        if (++begin == end || *begin != static_cast<val_t>('a') || ++begin == end) return false;

        ref_t ref3 = *begin;
        switch (std::tolower(ref3))
        {
        default:
            return false;

        case static_cast<val_t>('r'):
            mon = 2;
            ++begin;
            return true;

        case static_cast<val_t>('y'):
            mon = 4;
            ++begin;
            return true;
        }
    } // case m

    case static_cast<val_t>('a'): // apr aug
    {
        if (++begin == end) return false;
        ref_t ref2 = *begin;
        switch (std::tolower(ref2))
        {
        default:
            return false;

        case static_cast<val_t>('p'):
            if (++begin == end || std::tolower(*begin) != static_cast<val_t>('r')) return false;
            mon = 3;
            ++begin;
            return true;

        case static_cast<val_t>('u'):
            if (++begin == end || std::tolower(*begin) != static_cast<val_t>('g')) return false;
            mon = 7;
            ++begin;
            return true;
        }
    } // case a

    case static_cast<val_t>('s'): // sep
    {
        if (++begin == end || *begin != static_cast<val_t>('e') || ++begin == end ||
            *begin != static_cast<val_t>('p'))
            return false;

        mon = 8;
        ++begin;
        return true;
    } // case s

    case static_cast<val_t>('o'): // oct
    {
        if (++begin == end || *begin != static_cast<val_t>('c') || ++begin == end ||
            *begin != static_cast<val_t>('t'))
            return false;

        mon = 9;
        ++begin;
        return true;
    } // case o

    case static_cast<val_t>('n'): // nov
    {
        if (++begin == end || *begin != static_cast<val_t>('o') || ++begin == end ||
            *begin != static_cast<val_t>('v'))
            return false;

        mon = 10;
        ++begin;
        return true;
    } // case n

    case static_cast<val_t>('d'): // dec
    {
        if (++begin == end || *begin != static_cast<val_t>('e') || ++begin == end ||
            *begin != static_cast<val_t>('c'))
            return false;

        mon = 11;
        ++begin;
        return true;
    } // case n

    } // switch 1st-letter

    return false;
}

template <typename Iterator>
bool parse_ddmmyyyy(ddmmyyyy& dst, Iterator& begin, Iterator const& end, bool fixed = false)
{
    Iterator b(begin);
    if (b == end) return false;

    int day_digs = 2;
    if (fixed && *b == ' ')
    {
        ++b;
        day_digs = 1;
    }

    if (parse_short(dst.dd, 1, day_digs, b, end) && b != end && *b++ == '-' &&
        parse_month(dst.mm, b, end) && b != end && *b++ == '-' &&
        parse_short(dst.yyyy, 4, 4, b, end))
    {
        begin = b;
        return true;
    }

    return false;
}

template <typename Iterator>
bool parse_ddmmyyyy(ddmmyyyy& dst, Iterator const& begin, Iterator const& end, bool fixed = false)
{
    Iterator b(begin);
    return parse_ddmmyyyy<Iterator>(dst, b, end, fixed);
}

template <typename Iterator>
bool parse_date_full(date_full& dst, Iterator& begin, Iterator const& end)
{
    Iterator b(begin);
    if (b != end && *b == '"') ++b;
    ddmmyyyy d;
    if (!parse_ddmmyyyy(d, b, end, true)) return false;
    dst.dd = d.dd;
    dst.mm = d.mm;
    dst.yyyy = d.yyyy;

    if (b == end || *b++ != ' ' || !parse_short(dst.hour, 2, 2, b, end) || b == end ||
        *b++ != ':' || !parse_short(dst.min, 2, 2, b, end) || b == end || *b++ != ':' ||
        !parse_short(dst.sec, 2, 2, b, end) || b == end || *b++ != ' ' || b == end)
        return false;

    short zone_sign = 0;
    switch (*b++)
    {
    case '-':
        zone_sign = -1;
        break;
    case '+':
        zone_sign = 1;
        break;
    default:
        return false;
    }

    if (!parse_short(dst.zone, 4, 4, b, end)) return false;
    dst.zone *= zone_sign;
    return true;
}

template <typename Iterator>
bool parse_date_full(date_full& dst, Iterator const& begin, Iterator const& end)
{
    Iterator b(begin);
    return parse_date_full<Iterator>(dst, b, end);
}

// thread safe timegm
inline ::time_t timegm(struct ::tm* tm)
{
    ::time_t temp_ltime;
    struct tm temp_gm;

    temp_ltime = (tm ? ::mktime(tm) : 0);
    ::gmtime_r(&temp_ltime, &temp_gm);
    return (time_t)(temp_ltime + (temp_ltime - ::mktime(&temp_gm)));
}

} // util
} // yplatform
