#pragma once

#include <yplatform/util/safe_call.h>
#include <boost/core/noncopyable.hpp>

namespace yplatform {

struct execution_holder : boost::noncopyable
{
    std::function<void()> completion_handler;

    execution_holder(const std::function<void()>& completion_handler)
        : completion_handler(completion_handler)
    {
    }

    ~execution_holder()
    {
        yplatform::safe_call(completion_handler);
    }
};

using execution_holder_ptr = std::shared_ptr<execution_holder>;

}