#pragma once

#include <boost/histogram.hpp>

namespace yplatform { namespace hgram {

using namespace boost::histogram;

template <typename Histogram>
yplatform::ptree to_ptree(const Histogram& hgram)
{
    yplatform::ptree res;
    for (auto&& bucket : indexed(hgram, coverage::all))
    {
        yplatform::ptree bucket_ptree;

        yplatform::ptree border;
        border.put("", bucket.bin().lower());
        bucket_ptree.push_back(std::pair{ "", border });

        yplatform::ptree count;
        count.put("", *bucket);
        bucket_ptree.push_back(std::pair{ "", count });

        res.push_back(std::pair{ "", bucket_ptree });
    }
    return res;
}

}}
