#pragma once

#include <chrono>

namespace yplatform { namespace util {

class ntimer_t
{
    using clock = std::chrono::steady_clock;
    using nanoseconds = std::chrono::nanoseconds;

public:
    ntimer_t() : has_run_(0), running_(false)
    {
        start();
    }

    void start()
    {
        initiated_ = clock::now();
        running_ = true;
    }

    uint64_t stop() // nanoseconds
    {
        if (running_)
        {
            has_run_ = shot();
            running_ = false;
        }
        return has_run_;
    }

    uint64_t shot() const // nanoseconds
    {
        return static_cast<uint64_t>(
            std::chrono::duration_cast<nanoseconds>(clock::now() - initiated_).count());
    }

private:
    clock::time_point initiated_;
    uint64_t has_run_;
    bool running_;
};

}}
