#pragma once

namespace yplatform {

/*
    Allows to access private class members. Based on trick with
    disregard of accessibilities during explicit templates instantiation.

    See tests for examples.
*/

template <typename Class, typename Member>
struct private_access_tag
{
    typedef Member Class::*type;
    friend type get(private_access_tag<Class, Member>);
};

template <typename Tag, typename Tag::type MemberPtr>
struct private_access
{
    friend typename Tag::type get(Tag)
    {
        return MemberPtr;
    }
};

template <typename Tag, typename Class>
auto& get_field(Class& obj)
{
    return obj.*get(Tag());
}

}
