#pragma once

#include <boost/shared_ptr.hpp>
#include <memory>

template <template <class...> class DestPointer>
struct shared_ptr_cast;

template <>
struct shared_ptr_cast<std::shared_ptr>
{
    template <typename T>
    static std::shared_ptr<T> from(boost::shared_ptr<T> ptr)
    {
        return std::shared_ptr<T>(ptr.get(), [ptr](T*) {});
    }

    template <typename T>
    static std::shared_ptr<T> from(std::shared_ptr<T> ptr)
    {
        return ptr;
    }
};

template <>
struct shared_ptr_cast<boost::shared_ptr>
{
    template <typename T>
    static boost::shared_ptr<T> from(std::shared_ptr<T> ptr)
    {
        return boost::shared_ptr<T>(ptr.get(), [ptr](T*) {});
    }

    template <typename T>
    static boost::shared_ptr<T> from(boost::shared_ptr<T> ptr)
    {
        return ptr;
    }
};
