#pragma once

#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string/classification.hpp>
#include <string>
#include <vector>

namespace yplatform { namespace util {

template <template <typename...> class Collection, typename... Args>
void split(
    Collection<std::string, Args...>& target,
    const std::string& value,
    const std::string& separator)
{
    boost::split(target, value, boost::is_any_of(separator), boost::token_compress_on);
    if (target.size() && target.begin()->empty()) target.erase(target.begin());
    if (target.size() && target.rbegin()->empty()) target.erase(std::next(target.rbegin()).base());
}

inline std::vector<std::string> split(const std::string& value, const std::string& separator)
{
    std::vector<std::string> splitted;
    split(splitted, value, separator);
    return splitted;
}

inline std::vector<std::string> split_unique(const std::string& value, const std::string& separator)
{
    std::vector<std::string> result;
    split(result, value, separator);
    std::sort(result.begin(), result.end());
    result.erase(std::unique(result.begin(), result.end()), result.end());
    return result;
}

}}
