#pragma once

#include <string>
#include <type_traits>

namespace yplatform {

template <typename String>
class basic_sstream
{
public:
    using size_type = typename String::size_type;
    using char_type = typename String::value_type;

    basic_sstream(String& str) : str(str)
    {
    }

    basic_sstream(String& str, size_type sz) : basic_sstream(str)
    {
        this->str.reserve(sz + str.size());
    }

    basic_sstream& operator<<(char_type add)
    {
        str += add;
        return *this;
    }

    template <typename T, typename = typename std::enable_if<!std::is_arithmetic<T>::value>::type>
    basic_sstream& operator<<(const T& add)
    {
        str += add;
        return *this;
    }

private:
    String& str;
};

using sstream = basic_sstream<std::string>;
using wsstream = basic_sstream<std::wstring>;

template <typename T, typename = typename std::enable_if<std::is_arithmetic<T>::value>::type>
inline sstream& operator<<(sstream& out, T num)
{
    return out << std::to_string(num);
}

template <typename T, typename = typename std::enable_if<std::is_arithmetic<T>::value>::type>
inline wsstream& operator<<(wsstream& out, T num)
{
    return out << std::to_wstring(num);
}

}
