#pragma once

#include <boost/type_traits/aligned_storage.hpp>
#include <boost/type_traits/alignment_of.hpp>

namespace yplatform { namespace util {

/// Creates aligned storage for temporary values.
template <typename T>
struct storage
{
    bool created;

    typename boost::aligned_storage<sizeof(T), boost::alignment_of<T>::value>::type data;

    constexpr storage() noexcept : created(false)
    {
    }
    ~storage()
    {
        if (created) reinterpret_cast<T*>(&data)->~T();
    }
}; // struct storage

}}
