#pragma once

#ifdef __GNUC__

namespace yplatform {
class try_mutex
{
    try_mutex(const try_mutex&);
    try_mutex& operator=(const try_mutex&);

public:
    try_mutex() : x_(0)
    {
    }

    bool try_lock()
    {
        return __sync_val_compare_and_swap(&x_, 0, 1) == 0;
    }

    void unlock()
    {
        x_ = 0;
    }

private:
    volatile int x_;
};
} // namespace yplatform

#else

#include <boost/thread/mutex.hpp>

namespace yplatform {
typedef boost::try_mutex try_mutex;
} // namespace yplatform

#endif
