#pragma once

#include <tuple>

namespace yplatform { namespace util {

// Recusively goes down to next function, adding each tuple's element type
// to T... arguments.
template <int N, typename Tuple, typename... T>
struct results_tuple
    : results_tuple<N - 1, Tuple, typename std::tuple_element<N - 1, Tuple>::type::value_type, T...>
{
};

// Stops recursion then all elements in T...,
// defines final type tuple of elements with types same with element::value_type
// in the original tuple.
template <typename Tuple, typename... T>
struct results_tuple<0, Tuple, T...>
{
    typedef std::tuple<T...> type;
};

// Declares std::tuple<T1::value_type,T2::value_type,T3::value_type,...>
// for std::tuple<T1,T2,T3,...>
template <typename Tuple>
struct evaluate_results_tuple
{
private:
    typedef Tuple tuple_type;
    typedef typename std::tuple_element<std::tuple_size<tuple_type>::value - 1, tuple_type>::type
        last_element_type;

public:
    typedef typename results_tuple<
        std::tuple_size<tuple_type>::value - 1,
        tuple_type,
        typename last_element_type::value_type>::type type;
};

template <int...>
struct sequence
{
};

template <int N, int... S>
struct gensequence : gensequence<N - 1, N - 1, S...>
{
};

// Generates sequenc <0,1,2,3,...,N-1> in S...
template <int... S>
struct gensequence<0, S...>
{
    typedef sequence<S...> type;
};

// Calls function using std::get() and ellipsis mechanism.
template <typename Tuple, typename F, int... S, typename... Args>
inline auto unpack_tuple_and_call(Tuple&& tuple, F&& f, sequence<S...>, Args&&... args)
{
    return f(std::get<S>(std::forward<Tuple>(tuple))..., std::forward<Args>(args)...);
}

// Unpack tuple<T1,T2,T3> and calls a function f(T1,T2,T3,args...).
template <typename F, typename Tuple, typename... Args>
inline auto call_with_tuple_args(F&& f, Tuple&& tuple, Args&&... args)
{
    return unpack_tuple_and_call(
        std::forward<Tuple>(tuple),
        std::forward<F>(f),
        typename gensequence<std::tuple_size<typename std::decay<Tuple>::type>::value>::type(),
        std::forward<Args>(args)...);
}

}}