#pragma once

#include <boost/algorithm/string/predicate.hpp>
#include <boost/functional/hash/hash.hpp>
#include <unordered_map>

namespace yplatform {

namespace detail {
namespace {
const std::locale loc;
}

template <typename T>
struct iequal_to
{
    inline bool operator()(T const& x, T const& y) const
    {
        return boost::algorithm::iequals(x, y, loc);
    }
};

template <typename T>
struct ihash
{
    inline std::size_t operator()(T const& x) const
    {
        std::size_t seed = 0;
        for (typename T::const_iterator it = x.begin(); it != x.end(); ++it)
        {
            boost::hash_combine(seed, std::toupper(*it, loc));
        }
        return seed;
    }
};

} // namespace detail

template <typename Key, typename Value>
struct iunordered
{
    typedef std::unordered_multimap<Key, Value, detail::ihash<Key>, detail::iequal_to<Key>>
        multimap;

    typedef std::unordered_map<Key, Value, detail::ihash<Key>, detail::iequal_to<Key>> map;
};

} // namespace yplatform
