#pragma once

#include <iterator>

namespace yplatform { namespace util {

template <class Container>
class update_iterator : public std::iterator<std::output_iterator_tag, void, void, void, void>
{
protected:
    Container* container;

public:
    typedef Container container_type;

    explicit update_iterator(Container& x) : container(std::addressof(x))
    {
    }

    update_iterator<Container>& operator=(const typename Container::value_type& value)
    {
        std::pair<typename Container::iterator, bool> ret = container->insert(value);

        if (!ret.second) ret.first->second = value;
        return *this;
    }

    update_iterator<Container>& operator*()
    {
        return *this;
    }

    update_iterator<Container>& operator++()
    {
        return *this;
    }

    update_iterator<Container> operator++(int)
    {
        return *this;
    }
};

template <class Container>
update_iterator<Container> updater(Container& x)
{
    return update_iterator<Container>(x);
}

}}
