#pragma once

#include <variant>

namespace yplatform {

namespace detail {

template <class... Ts>
struct overloaded : Ts...
{
    using Ts::operator()...;
};
template <class... Ts>
overloaded(Ts...)->overloaded<Ts...>;

}

template <class Variant, class... Handlers>
inline decltype(auto) visit(Variant&& variant, Handlers&&... handlers)
{
    return std::visit(
        detail::overloaded{ std::forward<Handlers>(handlers)... }, std::forward<Variant>(variant));
}

}
