#pragma once

#include <memory>
#include <functional>
#include <type_traits>

namespace yplatform {

namespace detail {

template <typename T, typename H>
class weak_handler_wrapper
{
public:
    weak_handler_wrapper(std::weak_ptr<T> t, H&& h) : t_(t), h_(std::forward<H>(h))
    {
    }

    template <typename... Args>
    auto operator()(Args&&... args)
    {
        using return_type = std::invoke_result_t<H, Args...>;
        if (t_.lock())
        {
            return h_(std::forward<Args>(args)...);
        }
        else
        {
            return return_type();
        }
    }

private:
    std::weak_ptr<T> t_;
    typename std::decay<H>::type h_;
};

}

template <typename T, typename M, typename... Args>
auto weak_bind(M&& m, std::shared_ptr<T> t, Args&&... args)
{
    detail::weak_handler_wrapper wrapper(
        std::weak_ptr<T>(t), std::bind(std::forward<M>(m), t.get(), std::forward<Args>(args)...));
    return wrapper;
}

}
