#pragma once

#include <boost/shared_ptr.hpp>

namespace yplatform { namespace zerocopy {

class base_chunk
{
public:
    typedef char byte_t;
    virtual std::pair<byte_t*, std::size_t> buff() = 0;
    virtual ~base_chunk()
    {
    }
};

class const_base_chunk
{
public:
    typedef char byte_t;
    virtual std::pair<const byte_t*, std::size_t> buff() = 0;
    virtual ~const_base_chunk()
    {
    }
};

typedef boost::shared_ptr<base_chunk> base_chunk_ptr;
typedef boost::shared_ptr<const_base_chunk> const_base_chunk_ptr;
}}
