#include <yplatform/application/task_context.h>
#include <yplatform/util/unique_id.h>

namespace yplatform {

task_context::task_context(const std::string& val, const std::string& request_id)
    : begin_time_(boost::date_time::pos_infin)
    , cancelled_(false)
    , request_id_(request_id)
    , logger_(YGLOBAL_LOGGER)
{
    init(val);
}

task_context::task_context(const task_context& other)
    : begin_time_(other.begin_time_)
    , cancelled_(other.cancelled_)
    , deadline_(other.deadline_)
    , uniq_id_(other.uniq_id_)
    , request_id_(other.request_id_)
    , logger_(other.logger_)
{
}

task_context::~task_context()
{
}

task_context::ptree_ptr task_context::get_stat() const
{
    lock_t lock(mux());
    return core_get_stat();
}

task_context::ptree_ptr task_context::core_get_stat() const
{
    ptree_ptr result(new ptree());
    for (module_data_map::const_iterator i = modules_data_.begin(), i_end = modules_data_.end();
         i != i_end;
         ++i)
    {
        result->put_child(i->first, *i->second->get_stat());
    }
    return result;
}

bool task_context::contains_module_data(const std::string& name) const
{
    lock_t lock(mux());
    return core_contains_module_data(name);
}

void task_context::erase_module_data(const std::string& name)
{
    lock_t lock(mux());
    modules_data_.erase(name);
}

void task_context::init(const std::string& ini)
{
    uniq_id_ = ini.empty() ? util::make_unique_id(reinterpret_cast<unsigned long long>(this)) : ini;
}

}
