#include <yplatform/convert/iconv_impl.h>
#include <yplatform/convert/error.h>

#include <stdexcept>
#include <new>
#include <sstream>
#include <iconv.h>
#include <errno.h>

#define BAD_ICONV reinterpret_cast<::iconv_t>(-1)

namespace yplatform { namespace convert { namespace detail {

class iconv_impl::impl
{
public:
    inline impl(void) : ic_(BAD_ICONV)
    {
    }
    inline impl(const string& t, const string& f);

    inline ~impl();

    inline ::iconv_t& ic(void)
    {
        return this->ic_;
    }

private:
    ::iconv_t ic_;

    impl(const impl&);
    impl& operator=(const impl&);
};

iconv_impl::impl::impl(const string& __to, const string& __from) : ic_(BAD_ICONV)
{
    this->ic_ = ::iconv_open(__to.c_str(), __from.c_str());

    if (BAD_ICONV == ic_)
    {
        std::ostringstream os;
        os << "iconv_open: convertsion from '" << __from << "' to '" << __to << " is not supported";
        BOOST_THROW_EXCEPTION(not_supported_error(os.str()) << errno_info(errno));
    }
    ::iconv(this->ic_, 0, 0, 0, 0);
}

iconv_impl::impl::~impl()
{
    if (BAD_ICONV != this->ic_ && ::iconv_close(this->ic_) != 0)
        BOOST_THROW_EXCEPTION(illegal_sequence_error("iconv_close: can't free iconv descriptor"));
}

iconv_impl::iconv_impl(const string& __to, const string& __from)
    : ic_(new iconv_impl::impl(__to, __from))
{
    if (NULL == this->ic_.get()) throw std::bad_alloc();
}

bool iconv_impl::operator()(
    iconv_impl::CHAR*& __i,
    size_t& __isz,
    iconv_impl::CHAR*& __o,
    size_t& __osz)
{
#if 0 // DEBUG
  std::string in (__i, __isz);
  std::cout << "start iconv: __i=" << (void*) __i << " isz=" << __isz 
    << ", __o=" << (void*) __o << ", osz=" << __osz << ", str=" << in << "\n";
#endif
    size_t rc = __i ? ::iconv(this->ic_->ic(), &__i, &__isz, &__o, &__osz) :
                      ::iconv(this->ic_->ic(), 0, 0, &__o, &__osz);
#if 0 // DEBUG
  std::cout << "end iconv: __i=" << (void*) __i << " isz=" << __isz 
    << ", __o=" << (void*) __o << ", osz=" << __osz;

  std::cout << " : " << (static_cast<size_t> (-1) != rc ? "OK" : "FAIL");
  if (static_cast<size_t> (-1) == rc)
  {
    std::cout << " (err=" << errno << ")";
  }

  std::cout << "\n";
#endif

    return (static_cast<size_t>(-1) != rc);
}

}}}
