#include <yplatform/log/detail/syslog_resolve_facility.h>
#include <stdexcept>

#ifndef SYSLOG_NAMES
#define SYSLOG_NAMES
#include <sys/syslog.h>
#undef SYSLOG_NAMES
#else
#include <sys/syslog.h>
#endif

namespace yplatform { namespace log { namespace detail {

int syslog_resolve_facility(const std::string& name)
{
    for (size_t i = 0;; i++)
    {
        if (!facilitynames[i].c_name)
            throw std::runtime_error("Facility parameter contains not proper value");

        if (name == facilitynames[i].c_name) return facilitynames[i].c_val;
    }
}

}}}
