#include <yplatform/log.h>
#include <yplatform/log/service.h>

namespace yplatform { namespace log {

namespace detail {

void global_log_init(std::shared_ptr<detail::service> log_service)
{
    log::detail::global_service::instance().init(log_service);
    log::global_spdlog_logger::instance().init(*log_service);
    log::global_spdlog_logger::instance().get().set_log_prefix("global");
}

}

void log_init(const ptree&)
{
}
void log_load_cfg(const ptree&)
{
}

void global_log_init(
    const std::vector<std::shared_ptr<spdlog::logger>>& loggers,
    const std::vector<spdlog::sink_ptr>& sinks)
{
    detail::global_log_init(std::make_shared<detail::service>(loggers, sinks));
}

void global_log_init(const log::settings& settings)
{
    detail::global_log_init(std::make_shared<detail::service>(settings));
}

void global_log_init(const ptree& config)
{
    detail::global_log_init(std::make_shared<detail::service>(config));
}

void global_log_deinit()
{
    log::detail::global_service::instance().deinit();
}

void init_global_log_console()
{
    log::settings settings;
    log::sink_settings sink;
    sink.type = log::sink_type::stdout;
    settings.logs["global"].sinks.emplace_back(sink);
    settings.logs["global"].async = false;
    global_log_init(settings);
}

void init_global_log_file(const std::string& path)
{
    log::settings settings;
    log::sink_settings sink;
    sink.type = log::sink_type::file;
    sink.path = path;
    settings.logs["global"].sinks.emplace_back(sink);
    global_log_init(settings);
}

void init_console(boost::asio::io_service& io)
{
    log::settings settings;
    log::sink_settings sink;
    sink.type = yplatform::log::sink_type::stdout;
    settings.logs["global"].sinks.emplace_back(sink);
    init(io, settings);
}

void init_file(boost::asio::io_service& io, const std::string& path)
{
    log::settings settings;
    log::sink_settings sink;
    sink.type = yplatform::log::sink_type::file;
    sink.path = path;
    settings.logs["global"].sinks.emplace_back(sink);
    init(io, settings);
}

}}
