#include <yplatform/log/settings.h>
#include <boost/range/iterator_range.hpp>

namespace yplatform { namespace log {

sink_type sink_type_from_string(const std::string& type)
{
    if (type == "reopenable_file" || type == "file")
    {
        return sink_type::file;
    }
    else if (type == "stdout")
    {
        return sink_type::stdout;
    }
    if (type == "syslog")
    {
        return sink_type::syslog;
    }
    if (type == "reference")
    {
        return sink_type::reference;
    }
    else
    {
        throw std::runtime_error("Unsupported sink type: " + type);
    }
}

void settings::parse_ptree(const ptree& data)
{
    for (auto& log_data : data)
    {
        auto& name = log_data.first;
        auto& log_conf = log_data.second;
        log_settings log;
        log.async = log_conf.get("async", log.async);
        log.queue_size = log_conf.get("queue_size", log.queue_size);
        log.overflow_policy = log_conf.get("overflow_policy", log.overflow_policy);
        log.level = log_conf.get("level", log.level);
        log.format = log_conf.get("format", log.format);
        for (auto& sink_data : boost::make_iterator_range(log_data.second.equal_range("sinks")))
        {
            auto& sink_conf = sink_data.second;
            sink_settings sink;
            sink.type = sink_type_from_string(sink_conf.get<std::string>("type"));
            sink.name = sink_conf.get_optional<std::string>("name");
            if (sink.type == sink_type::file)
            {
                sink.force_flush = sink_conf.get("force_flush", sink.force_flush);
                sink.path = sink_conf.get<std::string>("path");
            }
            else if (sink.type == sink_type::syslog)
            {
                sink.facility = sink_conf.get<std::string>("facility");
                sink.ident = sink_conf.get("ident", sink.ident);
            }
            log.sinks.emplace_back(std::move(sink));
        }
        logs[name] = std::move(log);
    }
}

} // log
} // yplatform
