#pragma once

#include <yamail/data/deserialization/ptree.h>

#include <boost/range/algorithm/for_each.hpp>

namespace yamail::data::deserialization {

namespace foreign_ptree {

class Reader : public property_tree::detail::Reader<Reader> {
public:
    Reader(const ptree& pt) : level_(pt), iter_(level().begin()) {
    }

    template <typename Sequence, typename Tag>
    Reader onSequenceStart(Sequence & p, Tag tag) {
        auto retval = onSequenceStartImpl(p, tag);
        p.resize( retval.level().size() );
        return retval;
    }

    template <typename Sequence, std::size_t N, typename Tag>
    Reader onSequenceStart(Sequence (& p)[N], Tag tag) {
        return onSequenceStartImpl(p, tag);
    }

private:
    friend class property_tree::detail::Reader<Reader>;

    const ptree & level() const { return level_; }
    ptree::const_iterator & iter() { return iter_; }
    const ptree::const_iterator & iter() const { return iter_; }

    template <typename Struct, typename Tag>
    Reader onSequenceStartImpl(Struct & p, Tag tag) {
        return onStructStart(p, tag);
    }

    template <typename Struct, typename ...Args>
    Reader onSequenceStartImpl(Struct &, NamedItemTag<Args...> tag) {
        ptree filtered;
        boost::for_each(level().equal_range(name(tag)), [&](const auto& v) {
            filtered.add_child(v.first, v.second);
        });
        return Reader( filtered );
    }

    const ptree level_;
    ptree::const_iterator iter_;
};

} // namespace foreign_ptree

template <typename T>
inline void fromForeignPtree(const ptree& p, T& v) {
    foreign_ptree::Reader(p).apply(v);
}

template <typename T>
inline T fromForeignPtree(const ptree& p) {
    T retval = Access::construct<T>();
    fromForeignPtree(p, retval);
    return std::move(retval);
}

}
