#pragma once

#include <yamail/data/reflection/apply_visitor.h>
#include <yamail/data/reflection/details/type_traits.h>

#include <boost/property_tree/ptree.hpp>

namespace yamail::data::reflection {

using boost::property_tree::ptree;

/**
 * @brief Applies default visitor to ptree type object
 *
 * See http://www.boost.org/doc/html/boost_propertytree/parsers.html#boost_propertytree.parsers.json_parser
 * for mapping between ptree and json
 */
template <>
struct apply_visitor_default_impl<ptree, std::void_t<ptree>> {
    template <typename Visitor, typename Tag>
    static void apply(Visitor&& v, ptree& tree, Tag&& tag) {
        v.onPtree(tree, std::forward<Tag>(tag));
    }
};

template <>
struct apply_visitor_default_impl<const ptree, std::void_t<const ptree>> {
    template <typename Visitor, typename Tag>
    static void apply(Visitor&& v, const ptree& tree, Tag&& tag) {
        v.onPtree(tree, std::forward<Tag>(tag));
    }
};

} // namespace yamail::data::reflection
