#pragma once

#include <yamail/data/reflection/apply_visitor.h>
#include <yamail/data/reflection/details/type_traits.h>

#include <functional>

namespace yamail::data::reflection {

/**
 * @brief Applies default Visitor to an adapted enumeration object.
 */
template <typename T>
struct apply_visitor_default_impl<T, std::enable_if_t<is_enum_adapted_v<std::decay_t<T>>>> {
    template <typename Visitor, typename Enum, typename Tag>
    static void apply(Visitor&& v, const Enum& value, Tag&& tag) {
        static_assert(is_enum_adapted_v<Enum>, "argument must be an adapted enum");
        yamail::data::reflection::apply_visitor(std::forward<Visitor>(v), to_string(value), std::forward<Tag>(tag));
    }
    template <typename Visitor, typename Enum, typename Tag>
    static void apply(Visitor&& v, Enum& value, Tag&& tag) {
        static_assert(is_enum_adapted_v<Enum>, "argument must be an adapted enum");
        std::string buf;
        yamail::data::reflection::apply_visitor(std::forward<Visitor>(v), buf, std::forward<Tag>(tag));
        value = from_string<T>(buf);
    }
};

} // namespace yamail::data::reflection
