#pragma once

#include <yamail/data/reflection/apply_visitor.h>
#include <yamail/data/reflection/details/type_traits.h>
#include <yamail/data/reflection/tag.h>

#include <boost/range/algorithm/for_each.hpp>

namespace yamail::data::reflection {

/**
 * @brief Applies default Visitor to a map-like type
 *
 * Any type which meets `is_map` condition could be handled with this startegy.
 */
template <typename T>
struct apply_visitor_default_impl<T, std::enable_if_t<is_map_v<remove_cvref_t<T>>>> {
    template <typename Map, typename Visitor, typename Tag>
    static void apply(Visitor& v, Map&& map, Tag&& tag) {
        static_assert(is_map_v<remove_cvref_t<Map>>);
        decltype(auto) item_visitor = v.onMapStart(map, tag);
        boost::for_each(map, [&](auto& pair) {
            yamail::data::reflection::apply_visitor(item_visitor, pair.second, namedItemTag(pair.first));
        });
        v.onMapEnd(map, tag);
    }
};

} // namespace yamail::data::reflection
