#pragma once

#include <yamail/data/reflection/apply_visitor.h>
#include <yamail/data/reflection/details/type_traits.h>

#include <boost/optional.hpp>

#if __cplusplus >= 201703L

#include <optional>

#endif

namespace yamail::data::reflection {

template< class T >
struct is_optional : std::false_type {};

template< class T >
struct is_optional<boost::optional<T>> : std::true_type {};

#if __cplusplus >= 201703L

template< class T >
struct is_optional<std::optional<T>> : std::true_type {};

#endif

template <typename T>
constexpr auto is_optional_v = is_optional<T>::value;

/**
 * @brief Applies default Visitor to optional types like std::optional and boost::optional
 */
template <typename T>
struct apply_visitor_default_impl<T, std::enable_if_t<is_optional_v<remove_cvref_t<T>>>>{
    template <typename Optional, typename Visitor, typename Tag>
    static void apply (Visitor&& v, Optional&& optional, Tag&& tag) {
        static_assert(is_optional_v<remove_cvref_t<Optional>>);
        if (v.onOptional(optional, tag)) {
            yamail::data::reflection::apply_visitor(std::forward<Visitor>(v), *optional, std::forward<Tag>(tag));
        }
    };
};

} // namespace yamail::data::reflection
