#pragma once

#include <yamail/data/reflection/apply_visitor.h>
#include <yamail/data/reflection/details/type_traits.h>
#include <yamail/data/reflection/tag.h>

#include <boost/range/algorithm/for_each.hpp>

namespace yamail::data::reflection {

template <typename T>
using is_dynamic_range = std::bool_constant<is_range_v<T> &&
        !(is_string_v<T> || is_map_v<T> || std::is_array_v<T> || is_set_v<T>)>;

template <typename T>
constexpr auto is_dynamic_range_v = is_dynamic_range<T>::value;

/**
 * @brief Applies default Visitor to a sequence container like vector or list. This strategy
 * does not handle maps, or fixed-size arrays or strings representations.
 */
template <typename T>
struct apply_visitor_default_impl<T, std::enable_if_t<is_dynamic_range_v<remove_cvref_t<T>>>> {
    template <typename Range, typename Visitor, typename Tag>
    static void apply(Visitor&& v, Range&& cont, Tag&& tag) {
        static_assert(is_range_v<remove_cvref_t<Range>>);
        decltype(auto) item_visitor = v.onSequenceStart(cont, tag);
        boost::for_each(cont, [&](auto& item) {
            yamail::data::reflection::apply_visitor(item_visitor, item, SequenceItemTag{});
        });
        v.onSequenceEnd(cont, tag);
    }
};

} // namespace yamail::data::reflection
