#pragma once

#include <yamail/data/reflection/apply_visitor.h>
#include <yamail/data/reflection/details/type_traits.h>

#include <functional>

namespace yamail::data::reflection {

template <class T>
struct is_reference_wrapper : std::false_type { };

template <class T>
struct is_reference_wrapper<std::reference_wrapper<T>> : std::true_type { };

template <typename T>
constexpr auto is_reference_wrapper_v = is_reference_wrapper<T>::value;

/**
 * @brief Applies default Visitor to an object wrapped with `std::reference_wrapper`.
 */
template <typename T>
struct apply_visitor_default_impl<T, std::enable_if_t<is_reference_wrapper_v<remove_cvref_t<T>>>> {
    template <typename Visitor, typename Ref, typename Tag>
    static void apply(Visitor&& v, Ref&& value, Tag&& tag) {
        static_assert(is_reference_wrapper_v<remove_cvref_t<Ref>>);
        yamail::data::reflection::apply_visitor(std::forward<Visitor>(v), value.get(), std::forward<Tag>(tag));
    }
};


} // namespace yamail::data::reflection
