#pragma once

#include <yamail/data/reflection/apply_visitor.h>
#include <yamail/data/reflection/details/type_traits.h>
#include <yamail/data/reflection/tag.h>

#include <boost/fusion/include/for_each.hpp>

namespace yamail::data::reflection {

template <typename T>
struct is_sequence : std::bool_constant<
                    is_fusion_sequence_v<T> &&
                    !is_fusion_struct_v<T>> {};

template <typename T>
constexpr auto is_sequence_v = is_sequence<T>::value;

/**
 * @brief Applies default visitor for fixed-size sequences like tuples, arrays and
 * Boost.Fusion sequences except adapted structures and classes.
 */
template <typename T>
struct apply_visitor_default_impl<T, std::enable_if_t<is_sequence_v<remove_cvref_t<T>>>> {
    template <typename Tuple, typename Visitor, typename Tag>
    static void apply(Visitor&& v, Tuple&& cont, Tag&& tag) {
        static_assert(is_sequence_v<remove_cvref_t<Tuple>>);
        decltype(auto) item_visitor = v.onSequenceStart(cont, tag);
        boost::fusion::for_each(cont, [&](auto& item) {
            yamail::data::reflection::apply_visitor(item_visitor, item, SequenceItemTag{});
        });
        v.onSequenceEnd(cont, tag);
    }
};

} // namespace yamail::data::reflection
