#pragma once

#include <yamail/data/reflection/apply_visitor.h>
#include <yamail/data/reflection/details/type_traits.h>
#include <yamail/data/reflection/tag.h>

namespace yamail::data::reflection {

/**
 * @brief Applies default Visitor to a set-like type
 *
 * Any type which meets `is_set` condition could be handled with this startegy.
 */
template <typename T>
struct apply_visitor_default_impl<T, std::enable_if_t<is_set_v<remove_cvref_t<T>>>> {
    template <typename Visitor, typename Set, typename Tag>
    static void apply(Visitor&& v, Set&& s, Tag&& tag) {
        static_assert(is_set_v<remove_cvref_t<Set>>);

        std::vector<typename remove_cvref_t<Set>::key_type> vec(s.cbegin(), s.cend());
        yamail::data::reflection::apply_visitor(v, vec, tag);
        if constexpr (!std::is_const_v<std::remove_reference_t<Set>>) { 
            s.clear();
            s.insert(std::make_move_iterator(vec.begin()), std::make_move_iterator(vec.end()));
        }
    }
};

} // namespace yamail::data::reflection
