#pragma once

#include <yamail/data/reflection/apply_visitor.h>
#include <yamail/data/reflection/details/type_traits.h>

#include <boost/smart_ptr.hpp>
#include <memory>

namespace yamail::data::reflection {

template <class T>
struct is_smart_ptr : std::false_type {};

template <class T>
struct is_smart_ptr<std::unique_ptr<T>> : std::true_type {};
template <class T>
struct is_smart_ptr<std::shared_ptr<T>> : std::true_type {};
template <class T>
struct is_smart_ptr<std::weak_ptr<T>> :std::true_type {};
template <class T>
struct is_smart_ptr<boost::shared_ptr<T>> : std::true_type {};
template <class T>
struct is_smart_ptr<boost::weak_ptr<T>> : std::true_type {};
template <class T>
struct is_smart_ptr<boost::scoped_ptr<T>> : std::true_type {};
template <class T>
struct is_smart_ptr<boost::intrusive_ptr<T>> : std::true_type {};

template <typename T>
constexpr auto is_smart_ptr_v = is_smart_ptr<T>::value;

/**
 * @brief Applies default Visitor to a smart pointer types, like std::unique_ptr, std::shared_ptr and so on.
 */
template <typename T>
struct apply_visitor_default_impl<T, std::enable_if_t<is_smart_ptr_v<remove_cvref_t<T>>>> {
    template <typename Ptr, typename Visitor, typename Tag>
    static void apply (Visitor&& v, Ptr&& ptr, Tag&& tag) {
        static_assert(is_smart_ptr_v<remove_cvref_t<Ptr>>);
        if (v.onSmartPointer(ptr, tag)) {
            yamail::data::reflection::apply_visitor(std::forward<Visitor>(v), *ptr, tag);
        }
    }
};


} // namespace yamail::data::reflection
