#pragma once

#include <type_traits>


namespace yamail::data::reflection {

template<class T, class = void>
struct unwrap {
    using type = T;
    static constexpr bool value = false;
};

template<class T>
struct unwrap<T, std::void_t<typename T::Type>> {
    using type = typename T::Type;
    static constexpr bool value = true;
};

template<class T>
using unwrap_t = typename unwrap<T>::type;

template<class T>
static constexpr bool unwrap_v = unwrap<T>::value;

}
