#pragma once

#include <yamail/data/reflection/details/type_traits.h>
#include <boost/fusion/adapted/std_tuple.hpp>
#include <boost/fusion/include/std_tuple.hpp>
#include <boost/fusion/algorithm/query/find_if.hpp>
#include <boost/fusion/include/find_if.hpp>

namespace yamail::data::reflection {

template <typename ... Options>
constexpr auto options(Options&& ... opts) {
    return std::make_tuple(std::forward<Options>(opts)...);
}

template <typename T>
struct is_options : std::integral_constant<bool,
    boost::fusion::traits::is_sequence<std::decay_t<T>>::value> {};

template <typename T, typename Options>
constexpr decltype(auto) findOption(Options&& s) {
    static_assert(is_options<Options>::value, "Options must be Boost.Fusion sequence");
    return boost::fusion::find_if<std::is_same<boost::mpl::_, T>>(s);
}

template <typename T, typename Options>
constexpr decltype(auto) hasOption() {
    static_assert(is_options<Options>::value, "Options must be Boost.Fusion sequence");
    using i = decltype(findOption<T>(std::declval<const Options&>()));
    using end = decltype(boost::fusion::end(std::declval<const Options&>()));
    return negation<std::is_same<i, end>>{};
}

template <typename T, typename Options>
constexpr decltype(auto) hasOption(const Options&) {
    return hasOption<T, Options>();
}

} // namespace yamail::data::reflection
