#pragma once

#include <yplatform/tskv/detail/attribute.h>

namespace yplatform {
namespace tskv {

/**
 * Export of the tskv attribute entity.
 */
using detail::attribute;

/**
 * Attribute maps specialization.
 */
using attributes_map = detail::basic_attributes_map<char>;
using wattributes_map = detail::basic_attributes_map<wchar_t>;

/**
 * Returns key part of the attribute
 */
template <typename Key, typename Value>
inline const Key& key(const attribute<Key, Value>& v)
{ return detail::key(v); }

/**
 * Returns value part of the attribute
 */
template <typename Key, typename Value>
inline const Value& value(const attribute<Key, Value>& v)
{ return detail::value(v); }

/**
 * Creates attribute for tskv, using perfect forwarding, which means what in most
 * cases there no arguments are copied. If you want to store values, please use
 * std::make_tuple instead. Or attributes_map to hold more than one pairs which
 * can be determined only at runtime.
 */
template <typename Key, typename Value>
attribute<Key, Value> attr(Key&& key, Value&& value)
{ return attribute<Key, Value>(std::forward<Key>(key), std::forward<Value>(value)); }

/**
 * typed_log alias for attr function. It is needed for easy migration from typed_log.
 */
template <typename ... Args>
auto make_attr(Args&& ... args) -> decltype(attr(std::forward<Args>(args)...))
{ return attr(std::forward<Args>(args)...); }

} // namespace tskv
} // namespace yplatform
