#pragma once

#include <iostream>
#include <string>
#include <algorithm>
#include <boost/lexical_cast.hpp>
#include <yplatform/tskv/detail/tweak.h>
#include <yplatform/tskv/detail/basic_converter.h>

namespace yplatform {
namespace tskv {
namespace detail {

/**
 * This converter omits any character for which the filter returns true.
 * Please note what filter is not applicable to the numerics, boolean and void
 * pointer.
 */
template <typename Filter>
struct skip_converter : public basic_converter
{
    Filter filter;

    template <typename Ostream, typename T>
    Ostream& operator()(Ostream& s, T& v) const
    {
        return (*this)(s, boost::lexical_cast<string_type<Ostream>>(v));
    }

    __YPLATFORM_TSKV_TWEAK_BYPASS_POD_NUMERIC_TYPES

    template <typename Ostream>
    Ostream& operator()(Ostream& s, string_type<Ostream> v) const
    {
        v.erase(std::remove_if(v.begin(), v.end(), filter), v.end());
        s << v;
        return s;
    }
};

} // namespace detail
} // namespace tskv
} // namespace yplatform
