#pragma once

#include <yplatform/tskv/detail/iomanip.h>
#include <yplatform/tskv/detail/skip_converter.h>
#include <yplatform/tskv/detail/bypass_converter.h>
#include <yplatform/tskv/detail/utf_converter.h>
#include <yplatform/tskv/detail/filters.h>

namespace yplatform {
namespace tskv {

/**
 * This manipulator represents tskv line without any value filtering.
 */
constexpr detail::iomanip<detail::bypass_converter> bypass;

/**
 *  This manipulator represents tskv line with basic key and value filtering - it
 *  ommits "\r", "\n", "\t" characters in values.
 */
constexpr detail::iomanip<detail::skip_converter<detail::is_trn_filter>> basic;

/**
 *  This manipulator represents tskv line with utf text filtering.
 *  It screens "\r", "\n", "\t", "\\" characters and all non-printable characters
 *  according to the output stream locale.
 */
constexpr detail::iomanip<detail::utf_converter> utf;

/**
 *  This manipulator represents tskv line with utf text filtering ONLY FOR VALUE.
 *  It screens "\r", "\n", "\t", "\\" characters and all non-printable characters
 *  according to the output stream locale.
 */
constexpr detail::iomanip<detail::bypass_converter, detail::utf_converter> utf_value;

/**
 * This manipulator represents end of tskv line. It useful in multiline output
 * source code.
 */
constexpr detail::endl_t endl;

/**
 * This final action for iomanip is used to set ups final action for the stream_wrapper.
 * It adds std::endl at the underlying stream at destruction of the stream_wrapper or
 * when tskv::endl is used.
 */
constexpr detail::finalize_with_endl with_endl;

/**
 * This final action for iomanip is used to set ups final action for the stream_wrapper.
 * It omits std::endl at the underlying stream at destruction of the stream_wrapper or
 * when tskv::endl is used. This behavior is needed when the underlying stream
 * complete string with end of line by itself. E.g. spdlog stream require this manipulator.
 * This is DEFAULT behavior.
 */
constexpr detail::finalize_without_endl without_endl;

} // namespace tskv
} // namespace yplatform
