#!/usr/bin/env python
# -*- coding: utf-8 -*-
import requests
import argparse
import gzip
from io import BytesIO
import xml.etree.ElementTree as ET

parser = argparse.ArgumentParser()
parser.add_argument("--output",  help = "Path to the output file", required = True)
args = parser.parse_args()
response = requests.get('http://export.altay-api.search.yandex.net/rubrics2.xml.gz')
gzBuffer = BytesIO(response.content)
gzObject = gzip.GzipFile(fileobj = gzBuffer)
xmldata = gzObject.read()

#Simple check for downloaded file structure, to prevent build with garbage
ns = {'backa': 'http://maps.yandex.ru/backa/1.x'}
rootNode = ET.fromstring(xmldata)
if rootNode.tag != '{http://maps.yandex.ru/backa/1.x}Rubrics' :
    raise ValueError('Rubrics node expected as root')

rubrics = len(rootNode.findall('backa:Rubric', ns))
if rubrics < 2 :
    raise ValueError('Too few Rubric nodes')

#Write out
with open(args.output, 'wb') as out:
    out.write(xmldata)


