#!/usr/bin/env python
import sys
import urllib2
import json
import re
from lxml import etree

if len(sys.argv) != 2:
    print 'usage: {} <filename>'.format(sys.argv[0])
    exit(1)

tanker_url = urllib2.urlopen(
    'http://tanker-api.tools.yandex.net:3000/'
    'projects/export/json/?project-id=mpro&keyset-id=attr-values&language=ru')

task_type_labels = {}
for key, label in json.load(tanker_url)['ru']['attr-values'].items():
    match = re.match('outsource_region-task_type__([a-z_]+)', key)
    if match:
        task_type_labels[match.group(1)] = label

fname = sys.argv[1]
cfg = etree.parse(fname)
for node in cfg.xpath('/config/rates/task-types/task-type'):
    node.attrib['label-ru'] = task_type_labels[node.attrib['id']]
with open(fname, 'w') as out:
    cfg.write(out, pretty_print=True, encoding="utf-8", xml_declaration=True)
