# Проверка прав при работе с фидбэком

Основные операции с фидбэком:
* посмотреть по прямой ссылке
* увидеть в пинах
* увидеть в фидах
* модифицировать фидбэк (все операции: resolve, needInfo, hide, ...)

## Доступ на модификацию

Для изменения фидбэка нужно иметь доступ на модификацию и acl-пермишен на конкретную операцию.

На доступ к модификации фидбэка влияют:
* пермишен на hidden
* пермишен на internal_content

## Пермишены на конкретные операции

Список пермишенов, влияющих на доступ к конкретным операциям модификации фидбэка:
* ```Модерация-Фидбэк-Задания-Решение``` разрешает операции ```Reject, Accept, Open, Acquire```
* ```Модерация-Фидбэк-Задания-Запрос информации``` разрешает операцию ```NeedInfo```
* ```Модерация-Фидбэк-Задания-Смена типа``` разрешает операцию ```ChangeType```
* ```Модерация-Фидбэк-Задания-Смена позиции``` разрешает операцию ```ChangePosition```
* ```Модерация-Фидбэк-Задания-Скрытые``` разрешает операцию ```Hide```

## Доступ на просмотр
Доступ на просмотр, в основном, совпадает с доступом на модификацию.
Но есть исключения.

### В персональных фидах видно весь фидбэк
В НК можно выбрать объект на карте и пожаловаться на него или предложить его удалить.
В таком случае автором фидбэка становится пользователь.
Во всех других случаях фидбэк создаётся от имени робота.
Фиды, где пользователь может посмотреть созданные фидбэчины:
* `Уведомления - Мои Правки - Сообщения об ошибках`.
* `Уведомления - Мои Правки - Заявки на удаление`.

Модификацией считаются операции: `Accept, Reject, NeedInfo` и некоторые другие.
Фид, где пользователь может посмотреть модифицированные фидбэчины: `Уведомления - Мои Правки - Обработанные неточности`.

_Свой_ фидбэк пользователь всегда может посмотреть.
Это означает, что к такому фидбэку не применяются проверки:
* права на hidden
* права на internal_content
* попадание в назначенный preset

### С помощью механизма назначенных preset-ов можно выдать права только на просмотр
Подробности см. ниже по тексту.

## Доступ по [назначенным preset-ам](https://st.yandex-team.ru/NMAPS-14674)

Для гибкого регулирования прав на фидбэк сделали функционал _назначенных preset-ов_.

Preset можно назначить на пользователя через связанную с preset-ом роль.
У каждого preset-а есть 2 связанные роли:
* ```feedbackPreset_<имя preset-а>_Read```;
* ```feedbackPreset_<имя preset-а>_AllRights```.

Роль назначается через acl. При назначении роли можно указать зону AOI.

Для просмотра фидбэка требуется чтобы:
* фидбэк находился в preset-е
* связанная с этим пресетом роль (Read или AllRights) была назначена на пользователя
* если при назначении на пользователя роли указана зона, то требуется, чтобы фидбэк попадал в эту зону

Для доступа на модификацию фидбэка - условия те же.
Но подходит только связанная роль AllRights.

### Назначенные preset-ы без зоны

Обычным пользователям (aka common-ы) и менеджерам назначили preset-ы соответствующие их текущим правам на фидбэк и без указания зоны AOI.

Если зона AOI в назначенном preset-е не указана, имеется в виду, что preset назначен на весь мир.

Поддерживается любое количество preset-ов без зоны AOI.

### Ограничение доступа к ручке /feedback/pins

Фильтр ручки /feedback/pins будет ограничен в соответствии с назначенными на пользователя preset-ами без зоны.

Если preset-ов без зоны не назначено, ручка вернёт пустой набор пинов.

### Пересечение старых и новых проверок

Проверки доступа по preset-ам пересекаются с текущими провеками.
Доступность по hidden проверяется и через пермишены, и через назначенные preset-ы.

## Фильтр в UI

Фильтр фидбэка в UI используется при просмотре пинов и фидов.

Фильтр ограничивает доступное многообразие типов и источников:
1. Отображаются только существующие для выбранных источников типы фидбэка. **Например**, если выбрать единственный источник `experiment-1way` - в фильтре останется только тип `дороги`; потому что из этого источника существуют фидбэчины только этого типа.
2. Фильтр ограничивает типы и источники по глобальным пресетам; для этого используются ручки `PUT /feedback/tasks/types` и `PUT /feedback/tasks/sources`.
3. В фильтре могут оказаться недоступные типы и/или источники. Для понимания надо обратиться к разработчикам UI: @dfilatov, @pv-bocharov.
