# Workflow фидбэка в НК

## Как устроено сейчас

Сейчас у фидбэка есть поле ```workflow```.
Это либо ```feedback```, что означает пользовательский фидбэк,
либо ```task```, что означает гипотезу.

Для разного ```workflow``` - разные KPI на разбор и разные инструкции.

## [Проблема 1](https://st.yandex-team.ru/NMAPS-14758)
Кнопка "От пользователей" в фильтре фидбэка показывает источники, которые не надо разбирать по SLA пользовательского фидбэка.

Другими словами, кнопки фильтра "От пользователей" и "Предположения" - неюзабельны.
Вместо этого работники руками выбирают нужный набор источников.

## [Пожелание 2](https://st.yandex-team.ru/NMAPS-14258)
Хочется, чтобы набор допустимых резолюций различался для _пользовательского_ фидбэка и для предположений.

Например, резолюция "Недостаточно информации для исправления" для _пользовательского_ фидбэка не используется.

## Рассуждения-предположения

### Предположение 1
Мы всегда можем определить пользовательский фидбэк посмотрев на источник фидбэка.

### Рассуждение 2
Поле workflow является дублирующей информацией, т.к. выводится из остальных полей фидбэка.
Поэтому надо его _выпилить_.

## Вариант решения 1
Перестать использовать поле workflow для поиска в базе.
Вместо этого вычислять значение workflow по остальным полям фидбкэка.

Например, постулировать, что:
* ```workflow=feedback``` - это фидбэк из источников ```fbapi и fbapi-samsara```
* а ```workflow=task``` - фидбэк из всех остальных источников

Тогда, когда видим в запросе от UI ```workflow=feedback```,
в запросе в базу это превращается в ```AND source IN ['fbapi', 'fbapi-samsara']```

А если видим в запросе от UI ```workflow=task```,
в запросе в базу это превращается в ```AND source NOT IN ['fbapi', 'fbapi-samsara']```

### Технические подробности уровня API

Список ручек, которые принимают параметр ```workflow```:
* ```/feedback/tasks-feed```
* ```/feedback/tasks/stats/opened```
* ```/feedback/tasks/types```
* ```/feedback/tasks/sources```
* ```/feedback/tasks/regions-stat```
* ```/feedback/tasks/regions```
* ```/feedback/tasks/region-feed/$```
* ```/feedback/tasks/pins```

### Технические подробности уровня бэкэнда

Есть функция, которая по фидбэку возвращает ```workflow``` этого фидбэка.
Это значение отсылается на UI, чтобы отобразить в карточке фидбэка.

Есть функция, которая по ```workflow``` возвращает кусок условия ```WHILE```
, которое надо добавить через ```AND``` к остальным условиям, чтобы выбрать нужный workflow.
Эта функция используется в фильтрах для фидов и пинов фидбэка.
