# Права на просмотр фидбэка через пресеты

## Какая задача решается
После "переезда" в новый интерфейс разбора фидбека/гипотез по пресетам, выяснилось, что у коллег из КПБ и не только из КПБ достаточно много сценариев, когда фидбек не разбирается, но используется как источник информации.
Сейчас в acl (или иным другим способом) нет возможности отделить права на просмотр фидбека/гипотез от прав на разбор этого фидбека/гипотез: все, что пользователь может смотреть, он может и разбирать.

## Решение
Сейчас работает [так](https://docs.yandex-team.ru/nmaps/services/social/feedback_permissions).

Ту роль, которая сейчас единственная (с именем ```feedbackPreset_<имя preset-а>```), переименуем в ```feedbackPreset_<имя preset-а>_AllRights```.
Она означает наличие права на модификацию фидбэка.
Пермишены на конкретные операции будут, как и сейчас, требоваться для выполнения этих конкретных операций.

Добавим для Пресета ещё одну acl-роль с именем ```feedbackPreset_<имя preset-а>_Read```.
Если назначить пользователю только такую роль, то он сможет только смотреть фидбэк.


## Развитие решения до общего случая
Общий случай - это распределять права на конкретные операции с помощью механизма Пресетов.
Например, мы готовы доверить пользователю менять тип фидбэка в Казахстане, но ещё не готовы доверить ему менять тип фидбэка в Израиле.

Для этого дополнительно связываем с Пресетом по одной acl-роли на каждую операцию, которая сейчас регулируется пермишеном.

Роль, дающая право на конкретную операцию с фидбэком работает как пермишен на эту операцию, но ограничивается Зоной и условием из Пресета.
Пермишены на конкретные операции становятся не нужны. Их можно выпилить и использовать только роли, связанные с пресетами.
Роль на операцию подразумевает доступ к фидбэку на чтение.


Роль ```feedbackPreset_<имя preset-а>_AllRights``` означает наличие всех прав на фидбэк.

Такое решение позволяет отказаться от пермишенов на операции с фидбэком.
И использовать только проверку прав по пресетам.