# Новые уровни разбора фидбэка (aka processingLevel)

[Таска](https://st.yandex-team.ru/NMAPS-15466).

## Какие задачи решается

### Перенаправить старшему картографу

{% cut "Есть такое действие." %}

Действие разрешено только для источников `nmaps-complaint` и `nmaps-request-for-deletion`.

{% endcut %}

Сейчас при этом происходит смена типа на `Other-Heavy`.

Проблема: теряем исходный тип; не можем отдать разбирать разные типы разным людям, на графиках не видим разделение по типам.

### Разбирать масштабные работы в НК

Сейчас делают перенаправление в Трекер.

В трекере разбирать дольше, и этот процесс не залогирован и его не видно на графиках.
Правки не привязываются к фидбэку. Нет контроля качества.

### Не всем разрешать перенаправлять в Трекер 

Сейчас эта задача не решается. И много фидбэка ошибочно отправляют в Трекер.

## Как работают уровни разбора сейчас

У фидбэка есть свойство `Уровень разбора`.
Значения бывают: 0 и 1.
[Пример](https://nmaps.tst.maps.yandex.ru/#!/feedback/tasks/2147479?z=19&ll=37.604462%2C55.746786&l=nk%23sat) фидбэчины с 1м уровнем.

Пермишен `Модерация-Фидбэк-Задания-Уровни разбора-Уровень 1` разрешает доступ к фидбэка с 1го уровня.

Исходно все фидбэчины находятся на 0м уровне разбора.

Если пользователь резолвит фидбэк, и мы считаем, что за этим пользователем надо перепроверить, фидбэк не закрывается, а, вместо этого, переводится на 1й уровень разбора.

Сейчас предполагается, что уровень разбора - это число. Больше число - больше прав и умений нужно, чтобы разбирать фидбэк на этом уровне.

## Как предлагаю решать задачу

### Уровни разбора перестают быть иерархичными

Уровень разбора становится набором значений: `level_0`, `level_1`, `level_2`, `large-scale`.

Можно думать, что это корзина, в которой сейчас идёт обработка фидбэка.

### Для разных уровней - разные наборы допустимых операций

Для каждого уровня разбора в коде прописываем свой набор допустимых операций с фидбэком.

{% cut "Допустимые операции" %}

**level_0:**

С этого уровня фидбэк разбирают комоны.
Набор допустимых действий - совпадает с **level_1**.
Но у комонов не будет части кнопок в силу ограниченности первых в правах.

**level_1:**
* accept
* reject
* need info
* смена типа
* перенаправить "не гео" фидбек
* передать на 2-й уровень
* передать в масштабные работы

НЕ имеют возможности перенаправления фидбека в geoсontentfb и geoplatformfb

**level_2:**
* accept
* reject
* need info
* смена типа
* перенаправить "не гео" фидбек
* передать в масштабные работы
* перенаправить в geoсontentfb и geoplatformfb

**Масштабные работы:**
* accept
* передать на 2-й уровень

{% endcut %}

### Смена уровня разбора

Предполагаю, что перевод `level_1 -> level_2` будет выполнять кнопка "передать старшему картографу".
Она сейчас есть в списке `Перенаправить в ....`.

В этот же список предлагаю добавить пункты для переводов на допустимые уровни разбора.

Все допустимые с фидбэком операции, как и сейчас, будут перечислены в json-ке фидбэка.

У обычных пользователе не появится новых действий с фидбэком.

Смена уровня разбора - это новое действие с фидбэком.
Предлагаю сделать для него отдельную ручку.
Альтернатива: расширить функциональность ручки `PATCH /feedback/tasks/$`.

### Добавляем уровни разбора в preset-ы

На UI в preset (и, соответственно, фильтр фидбэка) добавляем уровни разбора.

Добавляем как набор значений. Аналогично типам: можно выбрать набор уровней или `Все`.

### Права на разные уровни разбора

В preset-е можно выбрать уровни разбора. И выдать работнику права только на тот уровень разбора, который ему нужно разбирать.
